﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/Ei8htPOS.Master" AutoEventWireup="true" CodeBehind="EditProduct.aspx.cs" Inherits="AZVIC.Ei8htPOS.WebUI.Admin.Masters.Product.EditProduct" %>

<%@ Register Assembly="CKEditor.NET" Namespace="CKEditor.NET" TagPrefix="CKEditor" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="pageheader">
        <h2>
            <i class="fa fa-user"></i>Manage Product
        </h2>
        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>You are here</li>
                <li><a href="../../Dashboard.aspx">Ei8ht POS</a></li>
                <li><a href="Products.aspx">Products</a></li>

                <li class="active">Manage Product</li>
            </ol>
        </div>

    </div>

    <div class="col-md-6 col-xs-12">

        <div class="row padTop10">
            <div class="col-md-12 col-xs-12">
                <asp:Label ID="lblMessage" runat="server" CssClass="labelerror" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Product Name
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:HiddenField ID="hdProductID" runat="server" />
                <asp:TextBox ID="txtProductName" runat="server" CssClass="textbox required" data-error="Product Name" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Category
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:DropDownList ID="ddlCategory" runat="server" CssClass="listbox" />
            </div>
        </div>
        <%--<div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Other Categories
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:CheckBoxList ID="cbListCategory" runat="server" RepeatDirection="Horizontal" RepeatColumns="4" RepeatLayout="Table" BorderStyle="Solid" BorderWidth="1px" />
            </div>
        </div>--%>
        <%--<div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Sub Category
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:DropDownList ID="ddlSubCategory" runat="server" CssClass="listbox" />
            </div>
        </div>--%>
        <%--<div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Other Categories
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:CheckBoxList ID="cbListCategory" CssClass="cwhite" runat="server" RepeatDirection="Horizontal" RepeatColumns="4" RepeatLayout="Table" BorderStyle="Solid" BorderWidth="1px" />
            </div>
        </div>--%>
        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Brand
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:DropDownList ID="ddlBrand" runat="server" CssClass="listbox required" data-error="Brand" />
            </div>
        </div>
        <%--<div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Color
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:DropDownList ID="ddlColor" runat="server" CssClass="listbox required" data-error="Color" />
            </div>
        </div>--%>
        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Size
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:DropDownList ID="ddlSize" runat="server" CssClass="listbox" />
            </div>
        </div>
        <%--<div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Dimensions
            </div>
            <div class="col-md-8 col-xs-12">
                <table class="cwhite">
                    <tr>
                        <td align="left">Height (CM):
                                <asp:TextBox ID="txtProductHeight" runat="server" CssClass="textbox mw100px required number" data-error="Height"
                                    Width="80px" />
                        </td>
                        <td align="left">Depth (CM):
                                <asp:TextBox ID="txtProductDepth" runat="server" CssClass="textbox mw100px required number" data-error="Depth"
                                    Width="80px" />
                        </td>
                        <td align="left">Width (CM):
                                <asp:TextBox ID="txtProductWidth" runat="server" CssClass="textbox mw100px required number" data-error="Width"
                                    Width="80px" />
                        </td>
                    </tr>
                </table>
            </div>
        </div>--%>
        <%-- <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Product Weight (Kg)
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:TextBox ID="txtProductWeight" runat="server" CssClass="textbox required number" data-error="Weight"
                    Width="80px" />
            </div>
        </div>--%>
        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Product Code
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:TextBox ID="txtProductCode" runat="server" CssClass="textbox" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Unit Price
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:TextBox ID="txtUnitPrice" runat="server" CssClass="textbox required number" Width="80px" data-error="Unit Price" />
                <asp:CheckBox ID="chkShowPrice" runat="server" Text="Show Price" CssClass="cwhite" Checked="true" Visible="false" />
            </div>
        </div>
        <div class="row padTop10" style="display: none;">
            <div class="col-md-4 col-xs-12 cwhite">
                Happy Hour Price
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:TextBox ID="txtHappyHourPrice" runat="server" CssClass="textbox number" Width="80px" data-error="Happy Hour Price" Text="0" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Actual stock
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:TextBox ID="txtActualStock" runat="server" CssClass="textbox number" data-error="Actual Stock"
                    Width="80px" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Reserve stock
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:TextBox ID="txtReserveStock" runat="server" CssClass="textbox number" data-error="Reserve Stock"
                    Width="80px" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Low stock Indication
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:TextBox ID="txtLowStockIndication" runat="server" CssClass="textbox number" data-error="Low Stock Indicator"
                    Width="80px" />
            </div>
        </div>
        <%--<div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Earliest available days
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:TextBox ID="txtEarliestAvailableDay" runat="server" CssClass="textbox required number" data-error="Earliest Available Day"
                    Width="80px" />
            </div>
        </div>--%>
        <%-- <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Warranty (in Years)
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:TextBox ID="txtProductWarrenty" runat="server" CssClass="textbox required number" data-error="Warranty in Years"
                    Width="80px" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Designer Information:
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:TextBox ID="txtDesignerInfo" runat="server" CssClass="textbox" />
            </div>
        </div>--%>
    </div>

    <div class="col-md-6 col-xs-12">
        <%--<div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Product Descriptions
            </div>
            <div class="col-md-8 col-xs-12">
                <div id="counter" class="counter">
                    2000 Characters Maximum
                        <div class="barcount">
                            <div class="bar bluebar" id="bar">
                            </div>
                        </div>
                    <div id="count" class="count">
                    </div>
                </div>
                <CKEditor:CKEditorControl runat="server" ID="txtProductDescriptions" Height="200"
                    ClientIDMode="Static" BasePath="~/Admin/Scripts/ckeditor" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Product Descriptions For Quote
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:TextBox ID="txtProductDescriptionsForQuote" runat="server" TextMode="MultiLine" Height="103px"
                    CssClass="textbox" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Additional Information<asp:HiddenField ID="hdAdditionalInfo" runat="server" />
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:FileUpload ID="fileAdditionalInfo" runat="server" CssClass="textbox cwhite" />
                <asp:HyperLink ID="lnkAdditionalInfo" runat="server" Text="View File" Target="_blank"
                    Visible="false" />
            </div>
        </div>--%>
        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Image 1<asp:HiddenField ID="hdImage1" runat="server" />
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:FileUpload ID="fileImage1" runat="server" CssClass="textbox cwhite" />
                <asp:HyperLink ID="lnkImage1" runat="server" Text="View Image" Visible="false" CssClass="deleteimg" />
                <img src="../../Images/Delete-icon.png" onclick="ConfirmDelete(this);" id="imgDelete1" class="anchor" width="24" height="24" runat="server" />
            </div>
        </div>
        <%-- <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Image 2<asp:HiddenField ID="hdImage2" runat="server" />
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:FileUpload ID="fileImage2" runat="server" CssClass="textbox cwhite" />
                <asp:HyperLink ID="lnkImage2" runat="server" Text="View Image" CssClass="deleteimg"
                    Visible="false" />
                <img src="../../Images/Delete-icon.png" onclick="ConfirmDelete(this);" id="imgDelete2" class="anchor" width="24" height="24" runat="server" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Image 3<asp:HiddenField ID="hdImage3" runat="server" />
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:FileUpload ID="fileImage3" runat="server" CssClass="textbox cwhite" />
                <asp:HyperLink ID="lnkImage3" runat="server" Text="View Image" Visible="false" CssClass="deleteimg" />
                <img src="../../Images/Delete-icon.png" onclick="ConfirmDelete(this);" id="imgDelete3" class="anchor" width="24" height="24" runat="server" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Image 4<asp:HiddenField ID="hdImage4" runat="server" />
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:FileUpload ID="fileImage4" runat="server" CssClass="textbox cwhite" />
                <asp:HyperLink ID="lnkImage4" runat="server" Text="View Image"
                    Visible="false" CssClass="deleteimg" />
                <img src="../../Images/Delete-icon.png" onclick="ConfirmDelete(this);" class="anchor" id="imgDelete4" width="24" height="24" runat="server" />
            </div>
        </div>
        <asp:PlaceHolder ID="PlaceHolder1" runat="server" Visible="false">
            <div class="row padTop10">
                <div class="col-md-4 col-xs-12 cwhite">
                    Image 5<asp:HiddenField ID="hdImage5" runat="server" />
                    <img src="../../Images/Delete-icon.png" onclick="ConfirmDelete(this);" class="anchor" id="imgDelete5" width="24" height="24" runat="server" />
                </div>
                <div class="col-md-8 col-xs-12">
                    <asp:FileUpload ID="fileImage5" runat="server" CssClass="textbox cwhite" Visible="false" />
                    <asp:HyperLink ID="lnkImage5" runat="server" Text="View Image" Visible="false" CssClass="deleteimg" />
                </div>
            </div>
        </asp:PlaceHolder>
        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                3D View URL<asp:HiddenField ID="hd3DViewURL" runat="server" />
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:TextBox ID="txt3DViewURL" runat="server" CssClass="textbox" /><br />
                <asp:HyperLink ID="lnk3DURL" runat="server" Text="View" Visible="false" NavigateUrl="javascript:void(0);" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Best Sale
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:CheckBox ID="chkIsBestSale" runat="server" Text="Best Sale" CssClass="cwhite" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                New Product
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:CheckBox ID="chkIsNew" runat="server" Text="Is New" CssClass="cwhite" />
            </div>
        </div>--%>
        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Inventory Tracking
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:CheckBox ID="chkIsSale" runat="server" Text="" CssClass="cwhite" />
            </div>
        </div>
        <%--<div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Miscellaneous Product
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:CheckBox ID="chkIsMiscellaneous" runat="server" Text="Is Miscellaneous" CssClass="cwhite" />
            </div>
        </div>

        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                AR Product
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:CheckBox ID="chkARProduct" runat="server" Text="Is AR Product" CssClass="cwhite" />
            </div>
        </div>

        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Accessories Type
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:DropDownList ID="ddlAccessoriesType" runat="server" CssClass="listbox">
                    <asp:ListItem Selected="True" Value="0" Text="-- Please Select --" />
                    <asp:ListItem Value="Glasses" Text="Glasses" />
                    <asp:ListItem Value="Jewellery" Text="Jewellery" />
                </asp:DropDownList>
            </div>
        </div>--%>


        <div class="row padTop10" style="display: none;">
            <div class="col-md-4 col-xs-12 cwhite">
                Share Inventory
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:DropDownList runat="server" ID="ddlShareInventory" DataTextField="ProductName" DataValueField="ProductsID" />
            </div>
        </div>

        <div class="row padTop10" style="display: none;">
            <div class="col-md-4 col-xs-12 cwhite">
                Add Different conversion sizes - For different inventory create a new product
            </div>
            <div class="col-md-8 col-xs-12">
                <input type="button" value="Add Sizes" onclick="OpenSizes();" class="btn btn-danger" id="btnAddSizeOpen" />
            </div>

        </div>

        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Sequence No
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:TextBox runat="server" ID="txtSequenceNo" onkeypress="return IsNumeric(event)"></asp:TextBox>
            </div>
        </div>

        <div class="row padTop10">
            <div class="col-md-4 col-xs-12 cwhite">
                Status
            </div>
            <div class="col-md-8 col-xs-12">
                <asp:CheckBox ID="chkIsActive" runat="server" Text="Active" CssClass="cwhite" Checked="True" />
            </div>
        </div>

    </div>
    <div class="row padTop10">
        <div class="col-md-12 text-center col-xs-12">
            <asp:Button ID="btnSave" runat="server" CssClass="btn btn-lg btn-primary" Text="Save" OnClientClick="return ValidateUI();"
                OnClick="btnSave_Click" />
            &nbsp;
                    <asp:Button ID="btnCancel" runat="server" CssClass="btn btn-primary btn-lg loading" Text="Cancel"
                        OnClick="btnCancel_Click" />
        </div>
    </div>
    <br />
    <br />




    <div class="row Footercenter">
        <center>All right reserved - www.ei8htpos.com &copy; 2015</center>

    </div>


    <div class="modal fade" id="divProductPreview" tabindex="-1" role="dialog" aria-labelledby="Product Preview" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="H2">Product Image Preview</h4>
                </div>
                <div class="modal-body">
                    <img id="imgProductImage" width="500" />
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="divSizes" tabindex="-1" role="dialog" aria-labelledby="Sizes Preview" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="H1">Product Sizes</h4>
                </div>
                <div class="modal-body">
                    <div class="tab-content responsive contentField">
                        <div id="Tables" class="tab-pane active cwhite" style="padding-top: 20px;">
                            <br />
                            <div class="row">
                                <div class="col-xs-12 col-md-2 col-sm-2">
                                    Target Size
                                </div>
                                <div class="col-xs-12 col-md-4 col-sm-4">
                                    <asp:DropDownList ID="ddlTargetSize" runat="server" />
                                </div>
                            </div>
                            <br />
                            <div class="row">
                                <div class="col-xs-12 col-md-2 col-sm-2">
                                    Target Size Qty
                                </div>
                                <div class="col-xs-12 col-md-4 col-sm-4">
                                    <asp:TextBox runat="server" ID="txtTargetSizeQty" onkeypress="return IsNumeric(event)" />
                                </div>
                            </div>
                            <br />
                            <div class="row">
                                <div class="col-xs-12 col-md-6 text-center">
                                    <asp:Button runat="server" ID="btnAddSize" OnClick="btnAddSize_Click" Text="Save" CssClass="btn btn-lg btn-danger" />
                                </div>
                            </div>
                            <br />
                            <div class="row">
                                <div class="col-md-12 col-xs-12 table-responsive">
                                    <asp:GridView runat="server" ID="gvSizes" AutoGenerateColumns="false" CssClass="table" DataKeyNames="ProductsXMeasurementID" OnRowCancelingEdit="gvSizes_RowCancelingEdit" OnRowEditing="gvSizes_RowEditing"
                                        OnRowDeleting="gvSizes_RowDeleting" OnRowDataBound="gvSizes_RowDataBound1">
                                        <Columns>
                                            <asp:TemplateField>
                                                <ItemTemplate>
                                                    <%# Container.DataItemIndex+1 %>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="Name">
                                                <ItemTemplate>
                                                    <%# Eval("TargetSizeName") %>
                                                </ItemTemplate>
                                                <EditItemTemplate>
                                                    <asp:DropDownList runat="server" ID="ddlTargetSizegrid" />
                                                </EditItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="Capacity">
                                                <ItemTemplate>
                                                    <%# Eval("TargetConversion") %>
                                                </ItemTemplate>
                                                <EditItemTemplate>
                                                    <asp:TextBox runat="server" ID="txtTargetQty" Text='<%# Eval("TargetConversion") %>' />
                                                </EditItemTemplate>
                                            </asp:TemplateField>
                                            <%--<asp:CommandField ControlStyle-CssClass="btn btn-primary" ShowEditButton="true" />--%>
                                            <asp:CommandField ControlStyle-CssClass="btn btn-primary" ShowDeleteButton="true" />
                                        </Columns>
                                        <HeaderStyle CssClass="tbl-header" />
                                        <RowStyle CssClass="tbl-row" />
                                        <AlternatingRowStyle CssClass="tbl-row" />
                                        <EmptyDataRowStyle />
                                        <EmptyDataTemplate>
                                            No Record found
                                        </EmptyDataTemplate>
                                        <EmptyDataRowStyle VerticalAlign="Middle" HorizontalAlign="Center" />
                                    </asp:GridView>
                                    <asp:Button runat="server" ID="btnDeleteSize" Style="display: none;" OnClick="btnDeleteSize_Click" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ScriptContent" runat="server">
    <script type="text/javascript">
        $(function () {
            setInterval("updateCount()", 100);
        });
        function updateCount() {
            var almost = CKEDITOR.instances["txtProductDescriptions"].getData();
            var main = almost.length * 100;
            var value = (main / 2000);
            var count = 2000 - almost.length;
            $('#count').html(almost.length);
            if (almost.length <= 2000) {
                $('#count').html(count).removeClass("red");
                $('#bar').animate({ "width": value + '%' }, 1).removeClass("redbar").addClass("bluebar");
            } else {
                $('#count').html(count).addClass("red");
                $('#bar').animate({ "width": '100%' }, 1).removeClass("bluebar").addClass("redbar");
            }
        }
        function OpenSizes() {
            $('#divSizes').modal('show');
        }
        function divProductPreview(imagesrc) {
            $('#imgProductImage').attr('src', imagesrc);
            $('#divProductPreview').modal();
        }
        function ConfirmDeleteSize() {
            if (confirm("Are you sure want to delete the product size?")) {
                $('#<%= btnDeleteSize.ClientID %>').click();
        }
    }
    function ConfirmDelete(obj) {
        if (confirm("Are you sure want to delete?")) {
            $(obj).parent().parent().find('input[type=hidden]').val('')
            $(obj).parent().find('a').hide();
            $(obj).hide();
        }
    }
    $(document).ready(function () {

        if ($('#<%= hdProductID.ClientID %>').val() != '') {
            $('#btnAddSize').prop('disabled', true);
        }
        else {
            $('#btnAddSize').prop('disabled', false);
        }
    });

    </script>
</asp:Content>
